<?php
/* --------------------------------------------------------------
   ParcelServiceMapper.php 2020-02-28
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2019 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\ParcelService\Repository;

use Gambio\Admin\ParcelService\Interfaces\ParcelService;
use Gambio\Admin\ParcelService\Model\ParcelServiceId;
use Gambio\Admin\ParcelService\Model\ParcelServiceIds;
use Gambio\Admin\ParcelService\ParcelServiceFactory;

class ParcelServiceMapper
{
    /**
     * @var ParcelServiceFactory
     */
    private $factory;
    
    
    /**
     * ParcelServiceMapper constructor.
     *
     * @param ParcelServiceFactory $factory
     */
    public function __construct(ParcelServiceFactory $factory)
    {
        $this->factory = $factory;
    }
    
    
    /**
     * Maps database data structure to internal domain data structure.
     *
     * @param array $data
     *
     * @return ParcelService
     */
    public function mapParcelService(array $data): ParcelService
    {
        return $this->factory->createParcelService((int)$data['parcel_service_id'],
                                                   $data['name'],
                                                   $data['default'] === '1',
                                                   $this->mapDescriptions($data['descriptions']));
    }
    
    
    /**
     * @param array $descriptionsData
     *
     * @return array
     */
    private function mapDescriptions(array $descriptionsData): array
    {
        $descriptions = [];
        foreach ($descriptionsData as $descriptionData) {
            $descriptions[] = [
                'languageId' => (int)$descriptionData['language_id'],
                'url'        => $descriptionData['url'],
                'comment'    => $descriptionData['comment'],
            ];
        }
        
        return $descriptions;
    }
    
    
    /**
     * Maps list of IDs to a internal Ids object.
     *
     * @param int[] $ids
     *
     * @return ParcelServiceIds
     */
    public function mapParcelServiceIds(array $ids): ParcelServiceIds
    {
        $collection = [];
        foreach ($ids as $reference => $id) {
            $collection[$reference] = ParcelServiceId::create($id);
        }
        
        return ParcelServiceIds::createWithReferences($collection);
    }
}